/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability;

import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.DataFlags;
import dev.toma.gunsrpg.api.common.data.IAimInfo;
import dev.toma.gunsrpg.api.common.data.IDebuffs;
import dev.toma.gunsrpg.api.common.data.IHandState;
import dev.toma.gunsrpg.api.common.data.IJamInfo;
import dev.toma.gunsrpg.api.common.data.IPerkProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerCapEntry;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.IProgressData;
import dev.toma.gunsrpg.api.common.data.IQuests;
import dev.toma.gunsrpg.api.common.data.IReloadInfo;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.ISkill;
import dev.toma.gunsrpg.common.capability.PlayerDataProvider;
import dev.toma.gunsrpg.common.capability.object.AimInfo;
import dev.toma.gunsrpg.common.capability.object.HandState;
import dev.toma.gunsrpg.common.capability.object.JamInfo;
import dev.toma.gunsrpg.common.capability.object.PlayerAttributes;
import dev.toma.gunsrpg.common.capability.object.PlayerDebuffs;
import dev.toma.gunsrpg.common.capability.object.PlayerPerkProvider;
import dev.toma.gunsrpg.common.capability.object.PlayerProgressionData;
import dev.toma.gunsrpg.common.capability.object.PlayerQuests;
import dev.toma.gunsrpg.common.capability.object.PlayerSkillProvider;
import dev.toma.gunsrpg.common.capability.object.ReloadInfo;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.S2C_UpdateCapabilityPacket;
import dev.toma.gunsrpg.sided.ClientSideManager;
import dev.toma.gunsrpg.util.IEventHandler;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;

public class PlayerData
implements IPlayerData {
    private final IEventHandler<IPlayerCapEntry> saveHandler = IEventHandler.newEventHandler();
    private final HandState handState;
    private final PlayerEntity player;
    private final AimInfo aimInfo;
    private final ReloadInfo reloadInfo;
    private final JamInfo jamInfo;
    private final PlayerSkillProvider skillProvider;
    private final PlayerDebuffs debuffs;
    private final PlayerAttributes attributes;
    private final PlayerPerkProvider perkProvider;
    private final PlayerProgressionData data;
    private final PlayerQuests quests;
    private IPlayerData.ISynchCallback callback;

    public PlayerData() {
        this(null);
    }

    public PlayerData(PlayerEntity player) {
        this.player = player;
        this.handState = new HandState(() -> this.sync(0));
        this.debuffs = new PlayerDebuffs();
        this.aimInfo = new AimInfo(this.handState);
        this.reloadInfo = new ReloadInfo(this::getAttributes, this.handState);
        this.jamInfo = new JamInfo(this.handState, player);
        this.attributes = new PlayerAttributes();
        this.skillProvider = new PlayerSkillProvider(player);
        this.perkProvider = new PlayerPerkProvider(this.attributes);
        this.data = new PlayerProgressionData(player, this.skillProvider);
        this.quests = new PlayerQuests(player);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::setSyncCallback);
        this.saveHandler.addListener(this.debuffs);
        this.saveHandler.addListener(this.aimInfo);
        this.saveHandler.addListener(this.jamInfo);
        this.saveHandler.addListener(this.attributes);
        this.saveHandler.addListener(this.skillProvider);
        this.saveHandler.addListener(this.perkProvider);
        this.saveHandler.addListener(this.data);
        this.saveHandler.addListener(this.quests);
        this.saveHandler.invoke(entry -> entry.setClientSynch(() -> this.requestSync(entry.getFlag())));
    }

    @Override
    public void tick() {
        this.debuffs.tick(this.player);
        this.reloadInfo.tick(this.player);
        this.aimInfo.tick(this.player);
        this.jamInfo.tick();
        this.skillProvider.tick(this.player);
        this.attributes.tick();
        this.perkProvider.tick();
    }

    @Override
    public IHandState getHandState() {
        return this.handState;
    }

    @Override
    public IAimInfo getAimInfo() {
        return this.aimInfo;
    }

    @Override
    public IReloadInfo getReloadInfo() {
        return this.reloadInfo;
    }

    @Override
    public IJamInfo getJamInfo() {
        return this.jamInfo;
    }

    @Override
    public ISkillProvider getSkillProvider() {
        return this.skillProvider;
    }

    @Override
    public IPerkProvider getPerkProvider() {
        return this.perkProvider;
    }

    @Override
    public IDebuffs getDebuffControl() {
        return this.debuffs;
    }

    @Override
    public IAttributeProvider getAttributes() {
        return this.attributes;
    }

    @Override
    public IProgressData getProgressData() {
        return this.data;
    }

    @Override
    public IQuests getQuests() {
        return this.quests;
    }

    @Override
    public void sync(int flags) {
        if (this.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.player;
            if (serverPlayer.field_71135_a == null) {
                return;
            }
            NetworkManager.sendClientPacket(serverPlayer, new S2C_UpdateCapabilityPacket(this.player.func_110124_au(), this.toNbt(flags), flags));
        }
    }

    @Override
    public void setSyncCallback(IPlayerData.ISynchCallback callback) {
        this.callback = callback;
    }

    @Override
    public void onSync() {
        if (this.callback != null) {
            this.callback.onSynch();
        }
    }

    @Override
    public List<IPlayerCapEntry> getSaveEntries() {
        return this.saveHandler.listAll();
    }

    @Override
    public CompoundNBT toNbt(int flags) {
        CompoundNBT nbt = new CompoundNBT();
        this.saveHandler.invokeIf(entry -> DataFlags.is(entry.getFlag(), flags), entry -> entry.toNbt(nbt));
        nbt.func_218657_a("handState", (INBT)this.handState.serializeNBT());
        return nbt;
    }

    @Override
    public void fromNbt(CompoundNBT nbt, int flags) {
        this.saveHandler.invokeIf(entry -> DataFlags.is(entry.getFlag(), flags), entry -> entry.fromNbt(nbt));
        this.handState.deserializeNBT(nbt.func_150297_b("handState", 10) ? nbt.func_74775_l("handState") : new CompoundNBT());
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    private void requestSync(int flag) {
        this.sync(flag);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setSyncCallback() {
        this.setSyncCallback(ClientSideManager.instance().onDataSync());
    }

    public static boolean hasActiveSkill(PlayerEntity player, SkillType<?> type) {
        LazyOptional<IPlayerData> optional = PlayerData.get(player);
        if (optional.isPresent()) {
            return ((IPlayerData)optional.orElse(null)).getSkillProvider().hasSkill(type);
        }
        return false;
    }

    public static <S extends ISkill> S getSkill(PlayerEntity player, SkillType<S> type) {
        LazyOptional<IPlayerData> optional = PlayerData.get(player);
        if (optional.isPresent()) {
            return ((IPlayerData)optional.orElse(null)).getSkillProvider().getSkill(type);
        }
        return null;
    }

    public static LazyOptional<IPlayerData> get(PlayerEntity player) {
        return player.getCapability(PlayerDataProvider.CAPABILITY, null);
    }

    public static IPlayerData getUnsafe(PlayerEntity player) {
        return (IPlayerData)PlayerData.get(player).orElseThrow(NullPointerException::new);
    }
}

